# Script to add French accents to fr.html using [char] codes
# e-grave=[char]0xE8, e-acute=[char]0xE9, e-circ=[char]0xEA
# a-grave=[char]0xE0, c-cedilla=[char]0xE7, o-circ=[char]0xF4
# u-grave=[char]0xF9, i-circ=[char]0xEE, E-acute=[char]0xC9

$File = "c:\Users\eforgues\Documents\Projects\GB10\GB10-Louis\www\fr.html"
$c = Get-Content $File -Raw -Encoding UTF8

# Helper chars
$ea = [char]0xE9  # e-acute
$eg = [char]0xE8  # e-grave
$ec = [char]0xEA  # e-circumflex
$ag = [char]0xE0  # a-grave
$cc = [char]0xE7  # c-cedilla
$oc = [char]0xF4  # o-circumflex
$Ea = [char]0xC9  # E-acute

# Title
$c = $c.Replace('<title>GB10 Manager - Documentation</title>', "<title>GB10 Manager - Documentation (FR)</title>")

# --- ORDERED replacements (longer first to avoid partial matches) ---

# Multi-word compound patterns
$c = $c.Replace('Personnalisation complete', "Personnalisation compl${eg}te")
$c = $c.Replace('Traduction complete', "Traduction compl${eg}te")
$c = $c.Replace('Statistiques temps reel', "Statistiques temps r${ea}el")
$c = $c.Replace('Informations Systeme', "Informations Syst${eg}me")
$c = $c.Replace('informations systeme', "informations syst${eg}me")
$c = $c.Replace('gestion systeme', "gestion syst${eg}me")
$c = $c.Replace('Onglet Systeme', "Onglet Syst${eg}me")
$c = $c.Replace('Monitoring Systeme', "Monitoring Syst${eg}me")
$c = $c.Replace('Telecharger un modele', "T${ea}l${ea}charger un mod${eg}le")
$c = $c.Replace('Modeles charges en memoire', "Mod${eg}les charg${ea}s en m${ea}moire")
$c = $c.Replace('modeles charges en memoire', "mod${eg}les charg${ea}s en m${ea}moire")
$c = $c.Replace('modeles charges', "mod${eg}les charg${ea}s")
$c = $c.Replace('Modeles charges', "Mod${eg}les charg${ea}s")
$c = $c.Replace('modeles installes', "mod${eg}les install${ea}s")
$c = $c.Replace('Modeles installes', "Mod${eg}les install${ea}s")
$c = $c.Replace('temps reel', "temps r${ea}el")
$c = $c.Replace('en-tete', "en-t${ec}te")
$c = $c.Replace('En-tete', "En-t${ec}te")
$c = $c.Replace('chiffre en', "chiffr${ea} en")
$c = $c.Replace('masque/affiche', "masqu${ea}/affich${ea}")
$c = $c.Replace('Etat de performance', "${Ea}tat de performance")
$c = $c.Replace('installe et fonctionnel', "install${ea} et fonctionnel")
$c = $c.Replace('installe (natif', "install${ea} (natif")
$c = $c.Replace('monte en', "mont${ea} en")
$c = $c.Replace('montes en', "mont${ea}s en")
$c = $c.Replace('complete de', "compl${eg}te de")
$c = $c.Replace("complete de l'interface", "compl${eg}te de l'interface")
$c = $c.Replace('complete.', "compl${eg}te.")
$c = $c.Replace('cote client', "c${oc}t${ea} client")
$c = $c.Replace('auto-generes', "auto-g${ea}n${ea}r${ea}s")
$c = $c.Replace('auto-genere', "auto-g${ea}n${ea}r${ea}")
$c = $c.Replace('par defaut', "par d${ea}faut")

# Long single words (sorted by length desc)
$c = $c.Replace('specialement', "sp${ea}cialement")
$c = $c.Replace('Fonctionnalites', "Fonctionnalit${ea}s")
$c = $c.Replace('fonctionnalites', "fonctionnalit${ea}s")
$c = $c.Replace('entierement', "enti${eg}rement")
$c = $c.Replace('intermediaire', "interm${ea}diaire")
$c = $c.Replace('representee', "repr${ea}sent${ea}e")
$c = $c.Replace('operationnel', "op${ea}rationnel")
$c = $c.Replace('telechargement', "t${ea}l${ea}chargement")
$c = $c.Replace('Telechargement', "T${ea}l${ea}chargement")
$c = $c.Replace('telecharger', "t${ea}l${ea}charger")
$c = $c.Replace('Telecharger', "T${ea}l${ea}charger")
$c = $c.Replace('telecharges', "t${ea}l${ea}charg${ea}s")
$c = $c.Replace('reinstaller', "r${ea}installer")
$c = $c.Replace('electrique', "${ea}lectrique")
$c = $c.Replace('precaution', "pr${ea}caution")
$c = $c.Replace('Verification', "V${ea}rification")
$c = $c.Replace('verification', "v${ea}rification")
$c = $c.Replace('Prerequis', "Pr${ea}requis")
$c = $c.Replace('prerequis', "pr${ea}requis")
$c = $c.Replace('redemarrage', "red${ea}marrage")
$c = $c.Replace('Redemarrage', "Red${ea}marrage")
$c = $c.Replace('redemarrer', "red${ea}marrer")
$c = $c.Replace('Redemarrer', "Red${ea}marrer")
$c = $c.Replace('supportees', "support${ea}es")
$c = $c.Replace('configuree', "configur${ea}e")
$c = $c.Replace('configurees', "configur${ea}es")
$c = $c.Replace('detectees', "d${ea}tect${ea}es")
$c = $c.Replace('detectes', "d${ea}tect${ea}s")
$c = $c.Replace('suggerees', "sugg${ea}r${ea}es")
$c = $c.Replace('executees', "ex${ea}cut${ea}es")
$c = $c.Replace('executee', "ex${ea}cut${ea}e")
$c = $c.Replace('executer', "ex${ea}cuter")
$c = $c.Replace('execution', "ex${ea}cution")
$c = $c.Replace('depannage', "d${ea}pannage")
$c = $c.Replace('depliable', "d${ea}pliable")
$c = $c.Replace('deployees', "d${ea}ploy${ea}es")
$c = $c.Replace('deployee', "d${ea}ploy${ea}e")
$c = $c.Replace('deployer', "d${ea}ployer")
$c = $c.Replace('deployes', "d${ea}ploy${ea}s")
$c = $c.Replace('ameliore', "am${ea}lior${ea}")
$c = $c.Replace('souhaites', "souhait${ea}s")
$c = $c.Replace('Parametres', "Param${eg}tres")
$c = $c.Replace('parametres', "param${eg}tres")
$c = $c.Replace('selectionnez', "s${ea}lectionnez")
$c = $c.Replace('Selectionnez', "S${ea}lectionnez")
$c = $c.Replace('Repertoire', "R${ea}pertoire")
$c = $c.Replace('repertoire', "r${ea}pertoire")
$c = $c.Replace('securisee', "s${ea}curis${ea}e")
$c = $c.Replace('securise', "s${ea}curis${ea}")
$c = $c.Replace('Securite', "S${ea}curit${ea}")
$c = $c.Replace('securite', "s${ea}curit${ea}")
$c = $c.Replace('Reference', "R${ea}f${ea}rence")
$c = $c.Replace('frequences', "fr${ea}quences")
$c = $c.Replace('Frequence', "Fr${ea}quence")
$c = $c.Replace('frequence', "fr${ea}quence")
$c = $c.Replace('installee', "install${ea}e")
$c = $c.Replace('installees', "install${ea}es")
$c = $c.Replace('installes', "install${ea}s")
$c = $c.Replace('integrees', "int${ea}gr${ea}es")
$c = $c.Replace('integree', "int${ea}gr${ea}e")
$c = $c.Replace('integre', "int${ea}gr${ea}")
$c = $c.Replace('generee', "g${ea}n${ea}r${ea}e")
$c = $c.Replace('generer', "g${ea}n${ea}rer")
$c = $c.Replace('genere', "g${ea}n${ea}r${ea}")
$c = $c.Replace('geree', "g${ea}r${ea}e")
$c = $c.Replace('gerer', "g${ea}rer")
$c = $c.Replace('derivee', "d${ea}riv${ea}e")
$c = $c.Replace('derive', "d${ea}riv${ea}")
$c = $c.Replace('evaluee', "${ea}valu${ea}e")
$c = $c.Replace('evalue', "${ea}valu${ea}")
$c = $c.Replace('chiffree', "chiffr${ea}e")
$c = $c.Replace('recommande', "recommand${ea}")
$c = $c.Replace('stabilite', "stabilit${ea}")
$c = $c.Replace('validite', "validit${ea}")
$c = $c.Replace('emetteur', "${ea}metteur")
$c = $c.Replace('regenere', "r${ea}g${ea}n${eg}re")
$c = $c.Replace('periodique', "p${ea}riodique")
$c = $c.Replace('specifique', "sp${ea}cifique")
$c = $c.Replace('specificite', "sp${ea}cificit${ea}")
$c = $c.Replace('traduisible', "traduisible")
$c = $c.Replace('Editable', "${Ea}ditable")

# Medium words
$c = $c.Replace('modeles', "mod${eg}les")
$c = $c.Replace('Modeles', "Mod${eg}les")
$c = $c.Replace('modele,', "mod${eg}le,")
$c = $c.Replace('modele.', "mod${eg}le.")
$c = $c.Replace('modele ', "mod${eg}le ")
$c = $c.Replace('Modele', "Mod${eg}le")
$c = $c.Replace('memoire', "m${ea}moire")
$c = $c.Replace('reseau', "r${ea}seau")
$c = $c.Replace('Systeme', "Syst${eg}me")
$c = $c.Replace('systeme', "syst${eg}me")
$c = $c.Replace('Systemes', "Syst${eg}mes")
$c = $c.Replace('systemes', "syst${eg}mes")
$c = $c.Replace('concue', "con${cc}ue")
$c = $c.Replace('recupere', "r${ea}cup${ea}r${ea}")
$c = $c.Replace('Recupere', "R${ea}cup${ea}r${ea}")
$c = $c.Replace('reponses', "r${ea}ponses")
$c = $c.Replace('reponse', "r${ea}ponse")
$c = $c.Replace('derniere', "derni${eg}re")
$c = $c.Replace('demarrage', "d${ea}marrage")
$c = $c.Replace('demarrer', "d${ea}marrer")
$c = $c.Replace('Demarrer', "D${ea}marrer")
$c = $c.Replace('arreter', "arr${ec}ter")
$c = $c.Replace('donnees', "donn${ea}es")
$c = $c.Replace('methode', "m${ea}thode")
$c = $c.Replace('detaille', "d${ea}taill${ea}")
$c = $c.Replace('Details', "D${ea}tails")
$c = $c.Replace('details', "d${ea}tails")
$c = $c.Replace('Schema', "Sch${ea}ma")
$c = $c.Replace('schema', "sch${ea}ma")
$c = $c.Replace('Etape', "${Ea}tape")
$c = $c.Replace('etape', "${ea}tape")
$c = $c.Replace('defaut', "d${ea}faut")
$c = $c.Replace('Acces', "Acc${eg}s")
$c = $c.Replace('acces', "acc${eg}s")
$c = $c.Replace('arret ', "arr${ec}t ")
$c = $c.Replace('Duree', "Dur${ea}e")
$c = $c.Replace('duree', "dur${ea}e")
$c = $c.Replace('Metriques', "M${ea}triques")
$c = $c.Replace('metriques', "m${ea}triques")
$c = $c.Replace('metrique', "m${ea}trique")
$c = $c.Replace('completes', "compl${eg}tes")
$c = $c.Replace('supervise', "supervis${ea}")

# Add back-to-language link in sidebar header
$c = $c.Replace(
    '<span class="doc-brand-sub">Documentation v1.0.0</span>',
    "<span class=""doc-brand-sub"">Documentation v1.0.0</span><a href=""index.html"" style=""font-size:0.72rem;color:var(--text-secondary);text-decoration:none;display:block;margin-top:0.3rem;"">&#8592; Changer de langue</a>"
)

# Write without BOM
$utf8NoBom = New-Object System.Text.UTF8Encoding $false
[System.IO.File]::WriteAllText($File, $c, $utf8NoBom)
Write-Output "Accents added to fr.html successfully"
